/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.service;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.exception.transaction.TransactionRollbackException;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseLayeredService;
import cn.herodotus.engine.oauth2.data.jpa.repository.HerodotusRegisteredClientRepository;
import cn.herodotus.engine.oauth2.data.jpa.utils.OAuth2AuthorizationUtils;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.server.authorization.repository.OAuth2ApplicationRepository;
import cn.hutool.core.date.DateUtil;
import java.io.Serializable;
import java.time.temporal.TemporalAccessor;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.OAuth2TokenFormat;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ClientSettings;
import org.springframework.security.oauth2.server.authorization.config.TokenSettings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class OAuth2ApplicationService
extends BaseLayeredService<OAuth2Application, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final HerodotusRegisteredClientRepository herodotusRegisteredClientRepository;
    private final OAuth2ApplicationRepository applicationRepository;

    @Autowired
    public OAuth2ApplicationService(RegisteredClientRepository registeredClientRepository, HerodotusRegisteredClientRepository herodotusRegisteredClientRepository, OAuth2ApplicationRepository applicationRepository) {
        this.registeredClientRepository = registeredClientRepository;
        this.herodotusRegisteredClientRepository = herodotusRegisteredClientRepository;
        this.applicationRepository = applicationRepository;
    }

    public BaseRepository<OAuth2Application, String> getRepository() {
        return this.applicationRepository;
    }

    @Transactional(rollbackFor={TransactionRollbackException.class})
    public OAuth2Application saveOrUpdate(OAuth2Application entity) {
        OAuth2Application application = (OAuth2Application)super.saveOrUpdate((Entity)entity);
        if (ObjectUtils.isNotEmpty((Object)((Object)application))) {
            this.registeredClientRepository.save(this.toRegisteredClient(application));
            log.debug("[Herodotus] |- OAuth2ApplicationService saveOrUpdate.");
            return application;
        }
        log.error("[Herodotus] |- OAuth2ApplicationService saveOrUpdate error, rollback data!");
        throw new NullPointerException("save or update OAuth2Application failed");
    }

    @Transactional(rollbackFor={TransactionRollbackException.class})
    public void deleteById(String id) {
        super.deleteById((Serializable)((Object)id));
        this.herodotusRegisteredClientRepository.deleteById((Serializable)((Object)id));
        log.debug("[Herodotus] |- OAuth2ApplicationService deleteById.");
    }

    public OAuth2Application authorize(String applicationId, String[] scopeIds) {
        HashSet<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();
        for (String scopeId : scopeIds) {
            OAuth2Scope scope = new OAuth2Scope();
            scope.setScopeId(scopeId);
            scopes.add(scope);
        }
        OAuth2Application oldApplication = (OAuth2Application)this.findById((Serializable)((Object)applicationId));
        oldApplication.setScopes(scopes);
        OAuth2Application newApplication = this.saveOrUpdate(oldApplication);
        log.debug("[Herodotus] |- OAuth2ApplicationService assign.");
        return newApplication;
    }

    public OAuth2Application findByClientId(String clientId) {
        OAuth2Application application = this.applicationRepository.findByClientId(clientId);
        log.debug("[Herodotus] |- OAuth2ApplicationService findByClientId.");
        return application;
    }

    private RegisteredClient toRegisteredClient(OAuth2Application application) {
        Set clientAuthenticationMethods = StringUtils.commaDelimitedListToSet((String)application.getClientAuthenticationMethods());
        Set authorizationGrantTypes = StringUtils.commaDelimitedListToSet((String)application.getAuthorizationGrantTypes());
        Set redirectUris = StringUtils.commaDelimitedListToSet((String)application.getRedirectUris());
        Set<OAuth2Scope> clientScopes = application.getScopes();
        return RegisteredClient.withId((String)application.getApplicationId()).clientId(application.getClientId()).clientSecret(application.getClientSecret()).clientSecretExpiresAt(DateUtil.toInstant((TemporalAccessor)application.getClientSecretExpiresAt())).clientAuthenticationMethods(authenticationMethods -> clientAuthenticationMethods.forEach(authenticationMethod -> authenticationMethods.add(OAuth2AuthorizationUtils.resolveClientAuthenticationMethod((String)authenticationMethod)))).authorizationGrantTypes(grantTypes -> authorizationGrantTypes.forEach(grantType -> grantTypes.add(OAuth2AuthorizationUtils.resolveAuthorizationGrantType((String)grantType)))).redirectUris(uris -> uris.addAll(redirectUris)).scopes(scopes -> clientScopes.forEach(clientScope -> scopes.add(clientScope.getScopeCode()))).clientSettings(this.createClientSettings(application)).tokenSettings(this.createTokenSettings(application)).build();
    }

    private ClientSettings createClientSettings(OAuth2Application application) {
        SignatureAlgorithm jwsAlgorithm;
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder();
        clientSettingsBuilder.requireAuthorizationConsent(application.getRequireAuthorizationConsent().booleanValue());
        clientSettingsBuilder.requireProofKey(application.getRequireProofKey().booleanValue());
        if (StringUtils.hasText((String)application.getJwkSetUrl())) {
            clientSettingsBuilder.jwkSetUrl(application.getJwkSetUrl());
        }
        if (ObjectUtils.isNotEmpty((Object)application.getAuthenticationSigningAlgorithm()) && ObjectUtils.isNotEmpty((Object)(jwsAlgorithm = SignatureAlgorithm.from((String)application.getAuthenticationSigningAlgorithm().name())))) {
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)jwsAlgorithm);
        }
        return clientSettingsBuilder.build();
    }

    private TokenSettings createTokenSettings(OAuth2Application application) {
        SignatureAlgorithm signatureAlgorithm;
        TokenSettings.Builder tokenSettingsBuilder = TokenSettings.builder();
        tokenSettingsBuilder.accessTokenTimeToLive(application.getAccessTokenValidity());
        tokenSettingsBuilder.refreshTokenTimeToLive(application.getRefreshTokenValidity());
        tokenSettingsBuilder.reuseRefreshTokens(application.getReuseRefreshTokens().booleanValue());
        tokenSettingsBuilder.accessTokenFormat(new OAuth2TokenFormat(application.getAccessTokenFormat().getFormat()));
        if (ObjectUtils.isNotEmpty((Object)application.getIdTokenSignatureAlgorithm()) && ObjectUtils.isNotEmpty((Object)(signatureAlgorithm = SignatureAlgorithm.from((String)application.getIdTokenSignatureAlgorithm().name())))) {
            tokenSettingsBuilder.idTokenSignatureAlgorithm(signatureAlgorithm);
        }
        return tokenSettingsBuilder.build();
    }
}

