/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.jackson2;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.JsonNodeUtils;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;

public class RegisteredClientDeserializer
extends JsonDeserializer<RegisteredClient> {
    private static final TypeReference<Set<ClientAuthenticationMethod>> CLIENT_AUTHENTICATION_METHOD_SET = new TypeReference<Set<ClientAuthenticationMethod>>(){};
    private static final TypeReference<Set<AuthorizationGrantType>> AUTHORIZATION_GRANT_TYPE_SET = new TypeReference<Set<AuthorizationGrantType>>(){};

    public RegisteredClient deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode root = (JsonNode)mapper.readTree(jsonParser);
        return this.deserialize(jsonParser, mapper, root);
    }

    private RegisteredClient deserialize(JsonParser parser, ObjectMapper mapper, JsonNode root) throws IOException {
        String id = JsonNodeUtils.findStringValue((JsonNode)root, (String)"id");
        String clientId = JsonNodeUtils.findStringValue((JsonNode)root, (String)"clientId");
        Instant clientIdIssuedAt = (Instant)JsonNodeUtils.findValue((JsonNode)root, (String)"clientIdIssuedAt", (TypeReference)JsonNodeUtils.INSTANT, (ObjectMapper)mapper);
        String clientSecret = JsonNodeUtils.findStringValue((JsonNode)root, (String)"clientSecret");
        Instant clientSecretExpiresAt = (Instant)JsonNodeUtils.findValue((JsonNode)root, (String)"clientSecretExpiresAt", (TypeReference)JsonNodeUtils.INSTANT, (ObjectMapper)mapper);
        String clientName = JsonNodeUtils.findStringValue((JsonNode)root, (String)"clientName");
        Set clientAuthenticationMethods = (Set)JsonNodeUtils.findValue((JsonNode)root, (String)"clientAuthenticationMethods", CLIENT_AUTHENTICATION_METHOD_SET, (ObjectMapper)mapper);
        Set authorizationGrantTypes = (Set)JsonNodeUtils.findValue((JsonNode)root, (String)"authorizationGrantTypes", AUTHORIZATION_GRANT_TYPE_SET, (ObjectMapper)mapper);
        Set redirectUris = (Set)JsonNodeUtils.findValue((JsonNode)root, (String)"redirectUris", (TypeReference)JsonNodeUtils.STRING_SET, (ObjectMapper)mapper);
        Set scopes = (Set)JsonNodeUtils.findValue((JsonNode)root, (String)"scopes", (TypeReference)JsonNodeUtils.STRING_SET, (ObjectMapper)mapper);
        ClientSettings clientSettings = (ClientSettings)JsonNodeUtils.findValue((JsonNode)root, (String)"clientSettings", (TypeReference)new TypeReference<ClientSettings>(){}, (ObjectMapper)mapper);
        TokenSettings tokenSettings = (TokenSettings)JsonNodeUtils.findValue((JsonNode)root, (String)"tokenSettings", (TypeReference)new TypeReference<TokenSettings>(){}, (ObjectMapper)mapper);
        return RegisteredClient.withId((String)id).clientId(clientId).clientIdIssuedAt(clientIdIssuedAt).clientSecret(clientSecret).clientSecretExpiresAt(clientSecretExpiresAt).clientName(clientName).clientAuthenticationMethods(methods -> methods.addAll(clientAuthenticationMethods)).authorizationGrantTypes(types -> types.addAll(authorizationGrantTypes)).redirectUris(uris -> uris.addAll(redirectUris)).scopes(s -> s.addAll(scopes)).clientSettings(clientSettings).tokenSettings(tokenSettings).build();
    }
}

