/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.jackson2;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.JsonNodeUtils;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;

public class OAuth2ClientAuthenticationTokenDeserializer
extends JsonDeserializer<OAuth2ClientAuthenticationToken> {
    private static final TypeReference<Set<HerodotusGrantedAuthority>> HERODOTUS_GRANTED_AUTHORITY_SET = new TypeReference<Set<HerodotusGrantedAuthority>>(){};

    public OAuth2ClientAuthenticationToken deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JacksonException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jsonParser);
        return this.deserialize(jsonParser, mapper, jsonNode);
    }

    private OAuth2ClientAuthenticationToken deserialize(JsonParser parser, ObjectMapper mapper, JsonNode root) throws IOException {
        Set authorities = (Set)JsonNodeUtils.findValue((JsonNode)root, (String)"authorities", HERODOTUS_GRANTED_AUTHORITY_SET, (ObjectMapper)mapper);
        RegisteredClient registeredClient = (RegisteredClient)JsonNodeUtils.findValue((JsonNode)root, (String)"registeredClient", (TypeReference)new TypeReference<RegisteredClient>(){}, (ObjectMapper)mapper);
        String credentials = JsonNodeUtils.findStringValue((JsonNode)root, (String)"credentials");
        ClientAuthenticationMethod clientAuthenticationMethod = (ClientAuthenticationMethod)JsonNodeUtils.findValue((JsonNode)root, (String)"clientAuthenticationMethod", (TypeReference)new TypeReference<ClientAuthenticationMethod>(){}, (ObjectMapper)mapper);
        OAuth2ClientAuthenticationToken clientAuthenticationToken = new OAuth2ClientAuthenticationToken(registeredClient, clientAuthenticationMethod, (Object)credentials);
        if (CollectionUtils.isNotEmpty((Collection)authorities)) {
            FieldUtil.setFieldValue((Object)clientAuthenticationToken, (String)"authorities", (Object)authorities);
        }
        return clientAuthenticationToken;
    }
}

