/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.crypto.processor;

import cn.herodotus.engine.assistant.core.domain.SecretKey;
import cn.herodotus.engine.protect.core.definition.AsymmetricCryptoProcessor;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import java.security.PrivateKey;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2CryptoProcessor
implements AsymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(SM2CryptoProcessor.class);
    private static final String FLAG = "04";

    public SecretKey createSecretKey() {
        SM2 sm2 = SmUtil.sm2();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String privateKey = HexUtil.encodeHexStr((byte[])BCUtil.encodeECPrivateKey((PrivateKey)sm2.getPrivateKey()));
        String publicKey = HexUtil.encodeHexStr((byte[])((BCECPublicKey)sm2.getPublicKey()).getQ().getEncoded(false));
        SecretKey secretKey = new SecretKey();
        secretKey.setPrivateKey(privateKey);
        secretKey.setPublicKey(publicKey);
        return secretKey;
    }

    public String decrypt(String content, String privateKey) {
        SM2 sm2 = SmUtil.sm2((String)privateKey, null);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String result = StrUtil.utf8Str((Object)sm2.decryptFromBcd(content, KeyType.PrivateKey));
        log.debug("[Herodotus] |- SM2 crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }

    public String encrypt(String content, String publicKey) {
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        String result = sm2.encryptBcd(content, KeyType.PublicKey);
        log.debug("[Herodotus] |- SM2 crypto encrypt data, value is : [{}]", (Object)result);
        return result;
    }
}

