/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.secure.interceptor;

import cn.herodotus.engine.protect.web.secure.interceptor.XssHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XssHttpServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper(request);
        log.trace("[Herodotus] |- XssHttpServletFilter wrapper request for [{}].", (Object)request.getRequestURI());
        filterChain.doFilter((ServletRequest)xssRequest, servletResponse);
    }
}

