/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.configuration;

import cn.herodotus.engine.protect.core.definition.AsymmetricCryptoProcessor;
import cn.herodotus.engine.protect.core.definition.SymmetricCryptoProcessor;
import cn.herodotus.engine.protect.web.annotation.ConditionalOnSMCrypto;
import cn.herodotus.engine.protect.web.annotation.ConditionalOnStandardCrypto;
import cn.herodotus.engine.protect.web.configuration.HttpCryptoConfiguration;
import cn.herodotus.engine.protect.web.crypto.processor.AESCryptoProcessor;
import cn.herodotus.engine.protect.web.crypto.processor.RSACryptoProcessor;
import cn.herodotus.engine.protect.web.crypto.processor.SM2CryptoProcessor;
import cn.herodotus.engine.protect.web.crypto.processor.SM4CryptoProcessor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class CryptoStrategyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpCryptoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Asymmetric Crypto] Auto Configure.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnStandardCrypto
    static class StandardCryptoConfiguration {
        StandardCryptoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public AsymmetricCryptoProcessor rsaCryptoProcessor() {
            RSACryptoProcessor rsaCryptoProcessor = new RSACryptoProcessor();
            log.debug("[Herodotus] |- Strategy [Standard Asymmetric RSA Crypto Processor] Auto Configure.");
            return rsaCryptoProcessor;
        }

        @Bean
        @ConditionalOnMissingBean
        public SymmetricCryptoProcessor aesCryptoProcessor() {
            AESCryptoProcessor aesCryptoProcessor = new AESCryptoProcessor();
            log.debug("[Herodotus] |- Strategy [Standard Symmetric AES Crypto Processor] Auto Configure.");
            return aesCryptoProcessor;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSMCrypto
    static class SMCryptoConfiguration {
        SMCryptoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public AsymmetricCryptoProcessor sm2CryptoProcessor() {
            SM2CryptoProcessor sm2CryptoProcessor = new SM2CryptoProcessor();
            log.debug("[Herodotus] |- Strategy [SM Asymmetric SM2 Crypto Processor] Auto Configure.");
            return sm2CryptoProcessor;
        }

        @Bean
        @ConditionalOnMissingBean
        public SymmetricCryptoProcessor sm4CryptoProcessor() {
            SM4CryptoProcessor sm4CryptoProcessor = new SM4CryptoProcessor();
            log.debug("[Herodotus] |- Strategy [SM Symmetric SM4 Crypto Processor] Auto Configure.");
            return sm4CryptoProcessor;
        }
    }
}

