/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.crypto.enhance;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.JacksonUtils;
import cn.herodotus.engine.protect.core.annotation.Crypto;
import cn.herodotus.engine.protect.core.exception.SessionInvalidException;
import cn.herodotus.engine.protect.web.crypto.processor.HttpCryptoProcessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);
    private HttpCryptoProcessor httpCryptoProcessor;

    public void setInterfaceCryptoProcessor(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        String methodName = methodParameter.getMethod().getName();
        Crypto crypto = (Crypto)methodParameter.getMethodAnnotation(Crypto.class);
        boolean isSupports = ObjectUtils.isNotEmpty((Object)crypto) && crypto.responseEncrypt();
        log.trace("[Herodotus] |- Is EncryptResponseBodyAdvice supports method [{}] ? Status is [{}].", (Object)methodName, (Object)isSupports);
        return isSupports;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String sessionKey = (String)request.getHeaders().get((Object)"X-Herodotus-Session").get(0);
        if (StringUtils.isBlank((CharSequence)sessionKey)) {
            log.warn("[Herodotus] |- Cannot find Herodotus Cloud custom session header. Use interface crypto founction need add X_HERODOTUS_SESSION to request header.");
            return body;
        }
        log.info("[Herodotus] |- EncryptResponseBodyAdvice begin encrypt data.");
        String methodName = methodParameter.getMethod().getName();
        String className = methodParameter.getDeclaringClass().getName();
        try {
            String bodyString = JacksonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(body);
            String result = this.httpCryptoProcessor.encrypt(sessionKey, bodyString);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                log.debug("[Herodotus] |- Encrypt response body for rest method [{}] in [{}] finished.", (Object)methodName, (Object)className);
                return result;
            }
            return body;
        }
        catch (JsonProcessingException e) {
            log.debug("[Herodotus] |- Encrypt response body for rest method [{}] in [{}] catch error, skip encrypt operation.", new Object[]{methodName, className, e});
            return body;
        }
        catch (SessionInvalidException e) {
            log.error("[Herodotus] |- Session is expired for encrypt response body for rest method [{}] in [{}], skip encrypt operation.", new Object[]{methodName, className, e});
            return body;
        }
    }
}

