/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.crypto.processor;

import cn.herodotus.engine.protect.core.definition.SymmetricCryptoProcessor;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(AESCryptoProcessor.class);

    public String createKey() {
        return RandomUtil.randomStringUpper((int)16);
    }

    public String decrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Bytes((CharSequence)key));
        byte[] result = aes.decrypt(Base64.decode((byte[])StrUtil.utf8Bytes((CharSequence)data)));
        log.debug("[Herodotus] |- AES crypto decrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }

    public String encrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Bytes((CharSequence)key));
        byte[] result = aes.encrypt(StrUtil.utf8Bytes((CharSequence)data));
        log.debug("[Herodotus] |- AES crypto encrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }
}

