/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.crypto.processor;

import cn.herodotus.engine.protect.core.definition.SymmetricCryptoProcessor;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4CryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(SM4CryptoProcessor.class);

    public String createKey() {
        SM4 sm4 = SmUtil.sm4();
        SecretKey secretKey = sm4.getSecretKey();
        byte[] encoded = secretKey.getEncoded();
        String result = HexUtil.encodeHexStr((byte[])encoded);
        log.debug("[Herodotus] |- SM4 crypto create hex key, value is : [{}]", (Object)result);
        return result;
    }

    public String decrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decodeHex((String)key));
        log.debug("[Herodotus] |- SM4 crypto decrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.decryptStr(data);
        log.debug("[Herodotus] |- SM4 crypto decrypt result is : [{}]", (Object)result);
        return result;
    }

    public String encrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decodeHex((String)key));
        log.debug("[Herodotus] |- SM4 crypto encrypt data [{}] with key : [{}]", (Object)data, (Object)key);
        String result = sm4.encryptHex(data);
        log.debug("[Herodotus] |- SM4 crypto encrypt result is : [{}]", (Object)result);
        return result;
    }
}

