/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.secure.interceptor;

import cn.herodotus.engine.protect.core.annotation.AccessLimited;
import cn.herodotus.engine.protect.core.exception.FrequentRequestsException;
import cn.herodotus.engine.protect.web.secure.stamp.AccessLimitedStampManager;
import cn.hutool.crypto.SecureUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class AccessLimitedInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitedInterceptor.class);
    private AccessLimitedStampManager accessLimitedStampManager;

    public void setAccessLimitedStampManager(AccessLimitedStampManager accessLimitedStampManager) {
        this.accessLimitedStampManager = accessLimitedStampManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.trace("[Herodotus] |- AccessLimitedInterceptor preHandle postProcess.");
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        AccessLimited accessLimited = method.getAnnotation(AccessLimited.class);
        if (ObjectUtils.isNotEmpty((Object)accessLimited)) {
            String annotationDuration;
            int maxTimes = this.accessLimitedStampManager.getSecureProperties().getAccessLimited().getMaxTimes();
            Duration expireDuration = Duration.ZERO;
            int annotationMaxTimes = accessLimited.maxTimes();
            if (annotationMaxTimes != 0) {
                maxTimes = annotationMaxTimes;
            }
            if (StringUtils.isNotBlank((CharSequence)(annotationDuration = accessLimited.duration()))) {
                try {
                    expireDuration = Duration.parse(annotationDuration);
                }
                catch (DateTimeParseException e) {
                    log.warn("[Herodotus] |- AccessLimited duration value is incorrect, on api [{}].", (Object)request.getRequestURI());
                }
            }
            String flag = handlerMethod.toString();
            log.debug("[Herodotus] |- AccessLimitedInterceptor process for request [{}].", (Object)flag);
            String key = SecureUtil.md5((String)flag);
            String expireKey = key + "_expire";
            Long times = (Long)this.accessLimitedStampManager.get(key);
            if (ObjectUtils.isEmpty((Object)times) || times == 0L) {
                if (!expireDuration.isZero()) {
                    this.accessLimitedStampManager.create(key, expireDuration);
                    this.accessLimitedStampManager.put(expireKey, System.currentTimeMillis(), expireDuration);
                } else {
                    this.accessLimitedStampManager.create(key);
                    this.accessLimitedStampManager.put(expireKey, System.currentTimeMillis());
                }
                return true;
            }
            log.debug("[Herodotus] |- AccessLimitedInterceptor request [{}] times.", (Object)times);
            if (times <= (long)maxTimes) {
                Duration newDuration = this.calculateRemainingTime(expireDuration, expireKey);
                this.accessLimitedStampManager.put(key, times + 1L, newDuration);
                return true;
            }
            throw new FrequentRequestsException("Requests are too frequent. Please try again later!");
        }
        return true;
    }

    private Duration calculateRemainingTime(Duration configuredDuration, String expireKey) {
        Long begin = (Long)this.accessLimitedStampManager.get(expireKey);
        Long current = System.currentTimeMillis();
        long interval = current - begin;
        log.debug("[Herodotus] |- AccessLimitedInterceptor operation interval [{}] millis.", (Object)interval);
        Duration duration = !configuredDuration.isZero() ? configuredDuration.minusMillis(interval) : this.accessLimitedStampManager.getExpire().minusMillis(interval);
        return duration;
    }
}

