/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.protect.web.secure.interceptor;

import cn.herodotus.engine.protect.core.annotation.Idempotent;
import cn.herodotus.engine.protect.core.exception.RepeatSubmissionException;
import cn.herodotus.engine.protect.web.secure.stamp.IdempotentStampManager;
import cn.hutool.crypto.SecureUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class IdempotentInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdempotentInterceptor.class);
    private static final String IDEMPOTENT_ATTRIBUTE = "Idempotent";
    private IdempotentStampManager idempotentStampManager;

    public void setIdempotentStampManager(IdempotentStampManager idempotentStampManager) {
        this.idempotentStampManager = idempotentStampManager;
    }

    private String generateKey(String sessionId, String url, String method) {
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            String key = SecureUtil.md5((String)(sessionId + ":" + url + ":" + method));
            log.debug("[Herodotus] |- IdempotentInterceptor key is [{}].", (Object)key);
            return key;
        }
        log.warn("[Herodotus] |- IdempotentInterceptor cannot create key, because sessionId is null.");
        return null;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.trace("[Herodotus] |- IdempotentInterceptor preHandle postProcess.");
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        if (idempotent != null) {
            String key;
            String sessionId = request.getHeader("X-Herodotus-Session");
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                HttpSession session = request.getSession();
                sessionId = session.getId();
            }
            if (StringUtils.isNotBlank((CharSequence)(key = this.generateKey(sessionId, request.getRequestURI(), request.getMethod())))) {
                String token = (String)this.idempotentStampManager.get(key);
                if (StringUtils.isBlank((CharSequence)token)) {
                    Duration configuredDuration = Duration.ZERO;
                    String annotationExpire = idempotent.expire();
                    if (StringUtils.isNotBlank((CharSequence)annotationExpire)) {
                        try {
                            configuredDuration = Duration.parse(annotationExpire);
                        }
                        catch (DateTimeParseException e) {
                            log.warn("[Herodotus] |- Idempotent duration value is incorrect, on api [{}].", (Object)request.getRequestURI());
                        }
                    }
                    if (!configuredDuration.isZero()) {
                        this.idempotentStampManager.create(key, configuredDuration);
                    } else {
                        this.idempotentStampManager.create(key);
                    }
                    request.setAttribute(IDEMPOTENT_ATTRIBUTE, (Object)key);
                    return true;
                }
                throw new RepeatSubmissionException("Don't Repeat Submission");
            }
        }
        return true;
    }
}

