/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.websocket.accelerator.interceptor;

import cn.herodotus.engine.websocket.accelerator.domain.WebSocketPrincipal;
import cn.herodotus.engine.websocket.accelerator.properties.WebSocketProperties;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class WebSocketChannelInterceptor
implements ChannelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebSocketChannelInterceptor.class);
    private WebSocketProperties webSocketProperties;

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            String token = (String)accessor.getNativeHeader(this.webSocketProperties.getPrincipalAttribute()).get(0);
            WebSocketPrincipal principal = (WebSocketPrincipal)accessor.getUser();
            log.debug("[Herodotus] |- Authentication user [{}], Token from frontend is [{}].", (Object)principal, (Object)token);
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(message);
        HttpSession httpSession = (HttpSession)accessor.getSessionAttributes().get("HTTP_SESSION");
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
    }

    public boolean preReceive(MessageChannel channel) {
        return false;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        return message;
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
    }
}

