/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.websocket.accelerator.interceptor;

import cn.herodotus.engine.websocket.accelerator.domain.WebSocketPrincipal;
import cn.herodotus.engine.websocket.accelerator.properties.WebSocketProperties;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

public class WebSocketHandshakeHandler
extends DefaultHandshakeHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandshakeHandler.class);
    private WebSocketProperties webSocketProperties;

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        Principal principal = request.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)principal)) {
            log.debug("[Herodotus] |- Get user principal from request, value is  [{}].", (Object)principal.getName());
            return principal;
        }
        Object user = null;
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(request);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest)) {
            user = httpServletRequest.getAttribute(this.webSocketProperties.getPrincipalAttribute());
            if (ObjectUtils.isEmpty((Object)user)) {
                user = httpServletRequest.getParameter(this.webSocketProperties.getPrincipalAttribute());
                if (ObjectUtils.isEmpty((Object)user)) {
                    user = httpServletRequest.getHeader("X-Herodotus-Session");
                } else {
                    log.debug("[Herodotus] |- Get user principal [{}] from request parameter, use parameter  [{}]..", user, (Object)this.webSocketProperties.getPrincipalAttribute());
                }
            } else {
                log.debug("[Herodotus] |- Get user principal [{}] from request attribute, use attribute  [{}]..", user, (Object)this.webSocketProperties.getPrincipalAttribute());
            }
        }
        if (!ObjectUtils.isEmpty(user)) {
            log.debug("[Herodotus] |- Get user principal [{}] from request header X_HERODOTUS_SESSION.", user);
            return new WebSocketPrincipal((String)user);
        }
        HttpSession httpSession = this.getSession(request);
        if (!ObjectUtils.isNotEmpty((Object)httpSession)) {
            log.error("[Herodotus] |- Cannot find session from websocket request.");
            return null;
        }
        user = httpSession.getAttribute(this.webSocketProperties.getPrincipalAttribute());
        if (ObjectUtils.isEmpty((Object)user)) {
            user = httpSession.getId();
            return new WebSocketPrincipal((String)user);
        }
        log.debug("[Herodotus] |- Get user principal [{}] from httpsession, use attribute  [{}].", user, (Object)this.webSocketProperties.getPrincipalAttribute());
        return new WebSocketPrincipal((String)user);
    }

    private HttpServletRequest getHttpServletRequest(ServerHttpRequest request) {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest serverRequest = (ServletServerHttpRequest)request;
            return serverRequest.getServletRequest();
        }
        return null;
    }

    private HttpSession getSession(ServerHttpRequest request) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(request);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest)) {
            return httpServletRequest.getSession(false);
        }
        return null;
    }
}

