/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.websocket.accelerator.processor;

import cn.herodotus.engine.websocket.accelerator.domain.WebSocketMessage;
import cn.herodotus.engine.websocket.accelerator.exception.IllegalChannelException;
import cn.herodotus.engine.websocket.accelerator.exception.PrincipalNotFoundException;
import cn.herodotus.engine.websocket.accelerator.processor.WebSocketMessageSender;
import cn.herodotus.engine.websocket.accelerator.properties.WebSocketProperties;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketClusterProcessor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClusterProcessor.class);
    private RedissonClient redissonClient;
    private WebSocketProperties webSocketProperties;
    private WebSocketMessageSender webSocketMessageSender;

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    public void setWebSocketMessageSender(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    public void toClusterUser(WebSocketMessage<String> webSocketMessage) {
        try {
            this.webSocketMessageSender.toUser(webSocketMessage);
        }
        catch (PrincipalNotFoundException e) {
            RTopic rTopic = this.redissonClient.getTopic(this.webSocketProperties.getTopic(), (Codec)new JsonJacksonCodec());
            rTopic.publish(webSocketMessage);
            log.debug("[Herodotus] |- Current instance can not found user [{}], publish message.", (Object)webSocketMessage.getTo());
        }
        catch (IllegalChannelException e) {
            log.error("[Herodotus] |- Web socket channel is incorrect.");
        }
    }

    public void afterPropertiesSet() throws Exception {
        RTopic topic = this.redissonClient.getTopic(this.webSocketProperties.getTopic());
        topic.addListener(WebSocketMessage.class, (charSequence, webSocketMessage) -> {
            log.debug("[Herodotus] |- Redisson received web socket sync message [{}]", webSocketMessage);
            this.webSocketMessageSender.toUser(webSocketMessage);
        });
    }
}

