/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.websocket.accelerator.properties;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="herodotus.websocket")
public class WebSocketProperties {
    private String endpoint = "stomp/websocketjs";
    private String broadcast = "topic";
    private String peerToPeer = "private";
    private List<String> applicationDestinationPrefixes;
    private String userDestinationPrefix;
    private String topic = "ws";
    private String principalAttribute = "openid";

    private String format(String endpoint) {
        if (StringUtils.isNotBlank((CharSequence)endpoint) && !StringUtils.startsWith((CharSequence)endpoint, (CharSequence)"/")) {
            return "/" + endpoint;
        }
        return endpoint;
    }

    public String getEndpoint() {
        return this.format(this.endpoint);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBroadcast() {
        return this.format(this.broadcast);
    }

    public void setBroadcast(String broadcast) {
        this.broadcast = broadcast;
    }

    public String getPeerToPeer() {
        return this.format(this.peerToPeer);
    }

    public void setPeerToPeer(String peerToPeer) {
        this.peerToPeer = peerToPeer;
    }

    public List<String> getApplicationDestinationPrefixes() {
        return this.applicationDestinationPrefixes;
    }

    public void setApplicationDestinationPrefixes(List<String> applicationDestinationPrefixes) {
        this.applicationDestinationPrefixes = applicationDestinationPrefixes;
    }

    public String[] getApplicationPrefixes() {
        List<String> prefixes = this.getApplicationDestinationPrefixes();
        if (CollectionUtils.isNotEmpty(prefixes)) {
            List<String> wellFormed = prefixes.stream().map(this::format).collect(Collectors.toList());
            String[] result = new String[wellFormed.size()];
            return wellFormed.toArray(result);
        }
        return new String[0];
    }

    public String getUserDestinationPrefix() {
        return this.format(this.userDestinationPrefix);
    }

    public void setUserDestinationPrefix(String userDestinationPrefix) {
        this.userDestinationPrefix = userDestinationPrefix;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }
}

