/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.websocket.accelerator.configuration;

import cn.herodotus.engine.websocket.accelerator.interceptor.WebSocketChannelInterceptor;
import cn.herodotus.engine.websocket.accelerator.interceptor.WebSocketHandshakeHandler;
import cn.herodotus.engine.websocket.accelerator.processor.WebSocketClusterProcessor;
import cn.herodotus.engine.websocket.accelerator.processor.WebSocketMessageSender;
import cn.herodotus.engine.websocket.accelerator.properties.WebSocketProperties;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;

@Configuration
@ConditionalOnBean(value={RedissonClient.class})
@EnableConfigurationProperties(value={WebSocketProperties.class})
@EnableWebSocketMessageBroker
public class WebSocketConfiguration
implements WebSocketMessageBrokerConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConfiguration.class);
    @Autowired
    private WebSocketProperties webSocketProperties;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private SimpUserRegistry simpUserRegistry;
    @Autowired
    private RedissonClient redissonClient;

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Plugin [Herodotus WebSocket] Auto Configure.");
    }

    @Bean
    public WebSocketChannelInterceptor webSocketChannelInterceptor() {
        WebSocketChannelInterceptor webSocketChannelInterceptor = new WebSocketChannelInterceptor();
        webSocketChannelInterceptor.setWebSocketProperties(this.webSocketProperties);
        log.trace("[Herodotus] |- Bean [Web Socket Inbound Channel Interceptor] Auto Configure.");
        return webSocketChannelInterceptor;
    }

    @Bean
    public WebSocketHandshakeHandler webSocketHandshakeHandler() {
        WebSocketHandshakeHandler webSocketHandshakeHandler = new WebSocketHandshakeHandler();
        webSocketHandshakeHandler.setWebSocketProperties(this.webSocketProperties);
        log.trace("[Herodotus] |- Bean [Web Socket Handshake Handler] Auto Configure.");
        return webSocketHandshakeHandler;
    }

    @Bean
    public WebSocketMessageSender webSocketMessageSender() {
        WebSocketMessageSender webSocketMessageSender = new WebSocketMessageSender();
        webSocketMessageSender.setSimpMessagingTemplate(this.simpMessagingTemplate);
        webSocketMessageSender.setSimpUserRegistry(this.simpUserRegistry);
        webSocketMessageSender.setWebSocketProperties(this.webSocketProperties);
        log.trace("[Herodotus] |- Bean [Web Socket Message Sender] Auto Configure.");
        return webSocketMessageSender;
    }

    @Bean
    @ConditionalOnBean(value={WebSocketMessageSender.class})
    public WebSocketClusterProcessor webSocketClusterProcessor(WebSocketMessageSender webSocketMessageSender) {
        WebSocketClusterProcessor webSocketClusterProcessor = new WebSocketClusterProcessor();
        webSocketClusterProcessor.setWebSocketProperties(this.webSocketProperties);
        webSocketClusterProcessor.setWebSocketMessageSender(webSocketMessageSender);
        webSocketClusterProcessor.setRedissonClient(this.redissonClient);
        log.trace("[Herodotus] |- Bean [Web Socket Cluster Processor] Auto Configure.");
        return webSocketClusterProcessor;
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.webSocketProperties.getEndpoint()}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.webSocketHandshakeHandler()).withSockJS();
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setThreadNamePrefix("herodotus-websocket-heartbeat-thread-");
        taskScheduler.initialize();
        registry.enableSimpleBroker(new String[]{this.webSocketProperties.getBroadcast(), this.webSocketProperties.getPeerToPeer()});
        Object[] applicationDestinationPrefixes = this.webSocketProperties.getApplicationPrefixes();
        if (ArrayUtils.isNotEmpty((Object[])applicationDestinationPrefixes)) {
            registry.setApplicationDestinationPrefixes((String[])applicationDestinationPrefixes);
        }
        if (StringUtils.isNotBlank((CharSequence)this.webSocketProperties.getUserDestinationPrefix())) {
            registry.setUserDestinationPrefix(this.webSocketProperties.getUserDestinationPrefix());
        }
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(10240).setSendBufferSizeLimit(10240).setSendTimeLimit(10000);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
        registration.interceptors(new ChannelInterceptor[]{this.webSocketChannelInterceptor()});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        return super.configureMessageConverters(messageConverters);
    }
}

