/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.converter.domain;

import cn.herodotus.oss.specification.domain.base.OwnerDomain;
import cn.herodotus.oss.specification.domain.object.ObjectDomain;
import com.aliyun.oss.model.OSSObjectSummary;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class ObjectSummaryToDomainConverter
implements Converter<OSSObjectSummary, ObjectDomain> {
    private final String delimiter;

    public ObjectSummaryToDomainConverter(String delimiter) {
        this.delimiter = delimiter;
    }

    public ObjectDomain convert(OSSObjectSummary source) {
        ObjectDomain objectDomain = new ObjectDomain();
        objectDomain.setBucketName(source.getBucketName());
        objectDomain.setObjectName(source.getKey());
        objectDomain.setETag(source.getETag());
        objectDomain.setSize(Long.valueOf(source.getSize()));
        objectDomain.setLastModified(source.getLastModified());
        objectDomain.setStorageClass(source.getStorageClass());
        if (ObjectUtils.isNotEmpty((Object)source.getOwner())) {
            OwnerDomain ownerAttributeDomain = new OwnerDomain();
            ownerAttributeDomain.setId(ownerAttributeDomain.getId());
            ownerAttributeDomain.setDisplayName(ownerAttributeDomain.getDisplayName());
            objectDomain.setOwner(ownerAttributeDomain);
        }
        objectDomain.setDir(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.delimiter) && StringUtils.contains((CharSequence)source.getKey(), (CharSequence)this.delimiter)));
        return objectDomain;
    }
}

