/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.repository;

import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToAbortMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToCompleteMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToInitiateMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToListMultipartUploadsRequest;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToListPartsRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToUploadPartCopyRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToUploadPartRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.CompleteMultipartUploadResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.InitiateMultipartUploadResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.MultipartUploadListingToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.PartListingToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.UploadPartCopyResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.UploadPartResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.specification.arguments.multipart.AbortMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.CompleteMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.InitiateMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListMultipartUploadsArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListPartsArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartCopyArguments;
import cn.herodotus.oss.specification.core.repository.OssMultipartUploadRepository;
import cn.herodotus.oss.specification.domain.multipart.AbortMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.CompleteMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.InitiateMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.ListMultipartUploadsDomain;
import cn.herodotus.oss.specification.domain.multipart.ListPartsDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartCopyDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartDomain;
import cn.herodotus.stirrup.kernel.definition.support.AbstractObjectPool;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunMultipartUploadRepository
extends BaseAliyunService
implements OssMultipartUploadRepository {
    private static final Logger log = LoggerFactory.getLogger(AliyunMultipartUploadRepository.class);

    public AliyunMultipartUploadRepository(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public InitiateMultipartUploadDomain initiateMultipartUpload(InitiateMultipartUploadArguments arguments) {
        String function = "initiateMultipartUpload";
        ArgumentsToInitiateMultipartUploadRequestConverter toRequest = new ArgumentsToInitiateMultipartUploadRequestConverter();
        InitiateMultipartUploadResultToDomainConverter toDomain = new InitiateMultipartUploadResultToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            InitiateMultipartUploadResult result = client.initiateMultipartUpload((InitiateMultipartUploadRequest)toRequest.convert(arguments));
            InitiateMultipartUploadDomain initiateMultipartUploadDomain = (InitiateMultipartUploadDomain)toDomain.convert(result);
            return initiateMultipartUploadDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public UploadPartDomain uploadPart(UploadPartArguments arguments) {
        String function = "uploadPart";
        ArgumentsToUploadPartRequestConverter toRequest = new ArgumentsToUploadPartRequestConverter();
        UploadPartResultToDomainConverter toDomain = new UploadPartResultToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            UploadPartResult result = client.uploadPart((UploadPartRequest)toRequest.convert(arguments));
            UploadPartDomain uploadPartDomain = (UploadPartDomain)toDomain.convert(result);
            return uploadPartDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public UploadPartCopyDomain uploadPartCopy(UploadPartCopyArguments arguments) {
        String function = "uploadPartCopy";
        ArgumentsToUploadPartCopyRequestConverter toRequest = new ArgumentsToUploadPartCopyRequestConverter();
        UploadPartCopyResultToDomainConverter toDomain = new UploadPartCopyResultToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            UploadPartCopyResult result = client.uploadPartCopy((UploadPartCopyRequest)toRequest.convert(arguments));
            UploadPartCopyDomain uploadPartCopyDomain = (UploadPartCopyDomain)toDomain.convert(result);
            return uploadPartCopyDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public CompleteMultipartUploadDomain completeMultipartUpload(CompleteMultipartUploadArguments arguments) {
        String function = "completeMultipartUpload";
        ArgumentsToCompleteMultipartUploadRequestConverter toRequest = new ArgumentsToCompleteMultipartUploadRequestConverter();
        CompleteMultipartUploadResultToDomainConverter toDomain = new CompleteMultipartUploadResultToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            CompleteMultipartUploadResult result = client.completeMultipartUpload((CompleteMultipartUploadRequest)toRequest.convert(arguments));
            CompleteMultipartUploadDomain completeMultipartUploadDomain = (CompleteMultipartUploadDomain)toDomain.convert(result);
            return completeMultipartUploadDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public AbortMultipartUploadDomain abortMultipartUpload(AbortMultipartUploadArguments arguments) {
        String function = "abortMultipartUpload";
        ArgumentsToAbortMultipartUploadRequestConverter toRequest = new ArgumentsToAbortMultipartUploadRequestConverter();
        OSS client = (OSS)this.getClient();
        try {
            client.abortMultipartUpload((AbortMultipartUploadRequest)toRequest.convert(arguments));
            AbortMultipartUploadDomain domain = new AbortMultipartUploadDomain();
            domain.setUploadId(arguments.getUploadId());
            domain.setBucketName(arguments.getBucketName());
            domain.setObjectName(arguments.getObjectName());
            AbortMultipartUploadDomain abortMultipartUploadDomain = domain;
            return abortMultipartUploadDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListPartsDomain listParts(ListPartsArguments arguments) {
        String function = "listParts";
        ArgumentsToListPartsRequestConverter toRequest = new ArgumentsToListPartsRequestConverter();
        PartListingToDomainConverter toDomain = new PartListingToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            PartListing listing = client.listParts((ListPartsRequest)toRequest.convert(arguments));
            ListPartsDomain listPartsDomain = (ListPartsDomain)toDomain.convert(listing);
            return listPartsDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListMultipartUploadsDomain listMultipartUploads(ListMultipartUploadsArguments arguments) {
        String function = "listMultipartUploads";
        ArgumentsToListMultipartUploadsRequest toRequest = new ArgumentsToListMultipartUploadsRequest();
        MultipartUploadListingToDomainConverter toDomain = new MultipartUploadListingToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            MultipartUploadListing listing = client.listMultipartUploads((ListMultipartUploadsRequest)toRequest.convert(arguments));
            ListMultipartUploadsDomain listMultipartUploadsDomain = (ListMultipartUploadsDomain)toDomain.convert(listing);
            return listMultipartUploadsDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

