/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.stirrup.kernel.definition.support.AbstractObjectPool;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AsyncProcessObjectRequest;
import com.aliyun.oss.model.AsyncProcessObjectResult;
import com.aliyun.oss.model.GetAsyncFetchTaskRequest;
import com.aliyun.oss.model.GetAsyncFetchTaskResult;
import com.aliyun.oss.model.SetAsyncFetchTaskRequest;
import com.aliyun.oss.model.SetAsyncFetchTaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunAsyncService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunAsyncService.class);

    public AliyunAsyncService(AbstractObjectPool<OSS> clientObjectPool) {
        super(clientObjectPool);
    }

    public SetAsyncFetchTaskResult setAsyncFetchTask(SetAsyncFetchTaskRequest request) {
        String function = "setAsyncFetchTask";
        OSS client = (OSS)this.getClient();
        try {
            SetAsyncFetchTaskResult setAsyncFetchTaskResult = client.setAsyncFetchTask(request);
            return setAsyncFetchTaskResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public GetAsyncFetchTaskResult getAsyncFetchTask(GetAsyncFetchTaskRequest request) {
        String function = "getAsyncFetchTask";
        OSS client = (OSS)this.getClient();
        try {
            GetAsyncFetchTaskResult getAsyncFetchTaskResult = client.getAsyncFetchTask(request);
            return getAsyncFetchTaskResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public AsyncProcessObjectResult asyncProcessObject(AsyncProcessObjectRequest request) {
        String function = "asyncProcessObject";
        OSS client = (OSS)this.getClient();
        try {
            AsyncProcessObjectResult asyncProcessObjectResult = client.asyncProcessObject(request);
            return asyncProcessObjectResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

