/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.solution.proxy;

import cn.herodotus.oss.solution.properties.OssProxyProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssProxyAddressFunction
implements Function<HttpServletRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(OssProxyAddressFunction.class);
    private final OssProxyProperties ossProxyProperties;

    public OssProxyAddressFunction(OssProxyProperties ossProxyProperties) {
        this.ossProxyProperties = ossProxyProperties;
    }

    @Override
    public String apply(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String path = uri.replace("/oss/multipart-upload/presigned", "");
        String queryString = request.getQueryString();
        Object params = queryString != null ? "?" + queryString : "";
        String target = this.ossProxyProperties.getDestination() + path + (String)params;
        log.debug("[Herodotus] |- Convert request [{}] to [{}].", (Object)uri, (Object)target);
        return target;
    }
}

