/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.solution.proxy;

import cn.herodotus.oss.solution.properties.OssProxyProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class OssProxyAddressConverter
implements Converter<String, String> {
    private static final Logger log = LoggerFactory.getLogger(OssProxyAddressConverter.class);
    private final OssProxyProperties ossProxyProperties;

    public OssProxyAddressConverter(OssProxyProperties ossProxyProperties) {
        this.ossProxyProperties = ossProxyProperties;
    }

    public String convert(String source) {
        if (this.ossProxyProperties.getEnabled().booleanValue()) {
            String endpoint = this.ossProxyProperties.getSource() + "/oss/multipart-upload/presigned";
            String target = StringUtils.replace((String)source, (String)this.ossProxyProperties.getDestination(), (String)endpoint);
            log.debug("[Herodotus] |- Convert presignedObjectUrl [{}] to [{}].", (Object)endpoint, (Object)target);
            return target;
        }
        return source;
    }
}

