/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.core.task;

import cn.hiboot.mcn.core.task.TaskThreadPool;
import cn.hiboot.mcn.core.util.McnAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class BatchExecutor<T> {
    private final TaskThreadPool taskThreadPool;
    private List<T> data;
    private final Consumer<List<T>> consumer;
    private final int batchSize;

    public BatchExecutor(int batchSize, Consumer<List<T>> consumer) {
        this(batchSize, consumer, null);
    }

    public BatchExecutor(int batchSize, Consumer<List<T>> consumer, TaskThreadPool taskThreadPool) {
        McnAssert.state(batchSize >= 0, "batchSize must gt 0");
        McnAssert.notNull(consumer, "consumer must not be null");
        this.batchSize = batchSize;
        this.consumer = consumer;
        this.data = new ArrayList<T>(batchSize);
        this.taskThreadPool = taskThreadPool;
    }

    public void add(T d) {
        if (this.data == null) {
            return;
        }
        this.data.add(d);
        if (this.data.size() % this.batchSize == 0) {
            this.doExecute(this.data);
            this.data = new ArrayList<T>(this.batchSize);
        }
    }

    private void doExecute(List<T> data) {
        if (this.taskThreadPool == null) {
            this.consumer.accept(data);
        } else {
            this.taskThreadPool.execute(() -> this.consumer.accept(data));
        }
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean sync) {
        if (!this.data.isEmpty()) {
            this.doExecute(this.data);
        }
        this.data = null;
        if (sync && this.taskThreadPool != null) {
            this.taskThreadPool.closeUntilAllTaskFinish();
        }
    }
}

