/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.core.task;

import cn.hiboot.mcn.core.task.TaskThreadPool;
import cn.hiboot.mcn.core.util.McnAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class TaskExecutor<T> {
    private final TaskThreadPool taskThreadPool;
    private final Iterable<T> iterable;
    private final int perBatchSize;

    public TaskExecutor(Iterable<T> iterable) {
        this(iterable, 1000);
    }

    public TaskExecutor(Iterable<T> iterable, int perBatchSize) {
        this(iterable, new TaskThreadPool(), perBatchSize);
    }

    public TaskExecutor(Iterable<T> iterable, TaskThreadPool taskThreadPool, int perBatchSize) {
        this.iterable = iterable;
        this.perBatchSize = perBatchSize;
        this.taskThreadPool = taskThreadPool;
    }

    public void execute(Consumer<List<T>> opr) {
        this.execute(Function.identity(), opr);
    }

    public <S> void execute(Function<T, S> convert, Consumer<List<S>> opr) {
        this.execute(convert, opr, false);
    }

    public <S> void execute(Function<T, S> convert, Consumer<List<S>> opr, boolean nullBreak) {
        McnAssert.notNull(convert, "convert must not be null");
        ArrayList<S> data = new ArrayList<S>(this.perBatchSize);
        for (T t : this.iterable) {
            S apply = convert.apply(t);
            if (apply == null) {
                if (!nullBreak) continue;
                break;
            }
            data.add(apply);
            if (data.size() != this.perBatchSize) continue;
            this.execute0(data, opr);
            data = new ArrayList();
        }
        if (!data.isEmpty()) {
            this.execute0(data, opr);
        }
        this.taskThreadPool.closeUntilAllTaskFinish();
    }

    private <S> void execute0(List<S> data, Consumer<List<S>> opr) {
        this.taskThreadPool.execute(() -> opr.accept(data));
    }
}

