/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.core.task;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskThreadPool
extends ThreadPoolExecutor {
    private final int workQueueSize;

    public TaskThreadPool() {
        this(Runtime.getRuntime().availableProcessors(), 10, "BatchTask");
    }

    public TaskThreadPool(int corePoolSize, int workQueueSize, String namePrefix) {
        this(corePoolSize, corePoolSize, workQueueSize, namePrefix);
    }

    public TaskThreadPool(int corePoolSize, int maximumPoolSize, int workQueueSize, String threadNamePrefix) {
        super(corePoolSize, maximumPoolSize, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingDeque<Runnable>(workQueueSize), new CustomThreadFactory(threadNamePrefix));
        this.workQueueSize = workQueueSize;
    }

    @Override
    public void execute(Runnable runnable) {
        while (this.blocking()) {
        }
        super.execute(runnable);
    }

    private boolean blocking() {
        return this.getPoolSize() == this.getMaximumPoolSize() && this.getQueue().size() == this.workQueueSize;
    }

    public void closeUntilAllTaskFinish() {
        this.shutdown();
        while (!this.isTerminated()) {
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger nextId = new AtomicInteger();

        public CustomThreadFactory(String name) {
            this.namePrefix = name + "-Worker";
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.namePrefix + this.nextId.getAndIncrement());
        }
    }
}

