/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.core.util;

import cn.hiboot.mcn.core.task.TaskThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public interface BatchOperation {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public int getBatchSize() {
        return 1000;
    }

    default public TaskThreadPool getExecutor() {
        return null;
    }

    default public <S> void operation(Iterable<S> all, Consumer<List<S>> consumer) {
        this.operation(all, consumer, true);
    }

    default public <S> void asyncOperation(Iterable<S> all, Consumer<List<S>> consumer) {
        this.operation(all, consumer, false);
    }

    default public <S> void operation(Iterable<S> all, Consumer<List<S>> consumer, boolean closeWaitFinish) {
        if (all == null) {
            return;
        }
        TaskThreadPool executor = this.getExecutor();
        ArrayList tmp = new ArrayList();
        for (S next : all) {
            tmp.add(next);
            if (tmp.size() % this.getBatchSize() != 0) continue;
            if (executor == null) {
                consumer.accept(tmp);
            } else {
                ArrayList finalTmp = tmp;
                executor.execute(() -> consumer.accept(finalTmp));
            }
            tmp = new ArrayList();
        }
        if (tmp.size() != 0) {
            consumer.accept(tmp);
        }
        tmp.clear();
        if (executor != null && closeWaitFinish) {
            executor.closeUntilAllTaskFinish();
        }
    }
}

