/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis.flex;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.context.ConstConfig;
import cn.hserver.plugin.mybatis.flex.bean.MybatisConfig;
import com.mybatisflex.core.MybatisFlexBootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;

public class MybatisFlexConfig {
    private static void loadMapperXml(Configuration configuration, String path) {
        HashMap<String, InputStream> xmlInput = new HashMap<String, InputStream>();
        if (ConstConfig.RUNJAR.booleanValue()) {
            MybatisFlexConfig.onlineFile(ConstConfig.CLASSPATH, path, xmlInput);
        } else {
            MybatisFlexConfig.developFile(ConstConfig.CLASSPATH + "/" + path, xmlInput);
        }
        xmlInput.forEach((k, v) -> {
            try {
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(v, configuration, k, configuration.getSqlFragments());
                xmlMapperBuilder.parse();
            }
            finally {
                try {
                    v.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void developFile(String path, Map<String, InputStream> xmlInput) {
        File[] files;
        File file = new File(path);
        if (file.exists() && null != (files = file.listFiles())) {
            File[] var4 = files;
            int var5 = files.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                File file2 = var4[var6];
                if (file2.isDirectory()) {
                    MybatisFlexConfig.developFile(file2.getAbsolutePath(), xmlInput);
                    continue;
                }
                try {
                    if (!file2.getAbsolutePath().endsWith(".xml")) continue;
                    xmlInput.put(file2.getAbsolutePath(), new FileInputStream(file2.getAbsolutePath()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void onlineFile(String path, String mapperPath, Map<String, InputStream> xmlInput) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)new URL(path).openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entry = jarFile.entries();
            while (entry.hasMoreElements()) {
                JarEntry jar = entry.nextElement();
                String name = jar.getName();
                if (!name.startsWith(mapperPath) || !name.endsWith(".xml")) continue;
                xmlInput.put(name, MybatisFlexConfig.class.getResourceAsStream("/" + name));
            }
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MybatisFlexBootstrap init(Set<Class<?>> mappers) {
        MybatisConfig mybatisConfig = (MybatisConfig)IocUtil.getBean(MybatisConfig.class);
        MybatisFlexBootstrap instance = MybatisFlexBootstrap.getInstance();
        mybatisConfig.getDataSources().forEach((arg_0, arg_1) -> ((MybatisFlexBootstrap)instance).addDataSource(arg_0, arg_1));
        mappers.forEach(arg_0 -> ((MybatisFlexBootstrap)instance).addMapper(arg_0));
        MybatisFlexBootstrap start = instance.start();
        Configuration configuration = start.getConfiguration();
        Interceptor[] plugins = mybatisConfig.getPlugins();
        if (plugins != null) {
            for (Interceptor plugin : plugins) {
                configuration.addInterceptor(plugin);
            }
        }
        MybatisFlexConfig.loadMapperXml(configuration, mybatisConfig.getMapperLocations());
        return start;
    }
}

