/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";

    public static String longToIpv4(long longIP) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        if (Validator.isIpv4(strIP)) {
            long[] ip = new long[4];
            int position1 = strIP.indexOf(".");
            int position2 = strIP.indexOf(".", position1 + 1);
            int position3 = strIP.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIP.substring(0, position1));
            ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIP.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return 0L;
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetUtil.isValidPort(port)) {
            return false;
        }
        try {
            new Socket(LOCAL_IP, port).close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        long ipNum = NetUtil.ipv4ToLong(ipAddress);
        long aBegin = NetUtil.ipv4ToLong("10.0.0.0");
        long aEnd = NetUtil.ipv4ToLong("10.255.255.255");
        long bBegin = NetUtil.ipv4ToLong("172.16.0.0");
        long bEnd = NetUtil.ipv4ToLong("172.31.255.255");
        long cBegin = NetUtil.ipv4ToLong("192.168.0.0");
        long cEnd = NetUtil.ipv4ToLong("192.168.255.255");
        isInnerIp = NetUtil.isInner(ipNum, aBegin, aEnd) || NetUtil.isInner(ipNum, bBegin, bEnd) || NetUtil.isInner(ipNum, cBegin, cEnd) || ipAddress.equals(LOCAL_IP);
        return isInnerIp;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new UtilException(e, "To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return new StringBuffer(ip.length()).append(ip.substring(0, ip.lastIndexOf(".") + 1)).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        if (StrUtil.isBlank(host)) {
            host = LOCAL_IP;
        }
        String destHost = null;
        int port = 0;
        int index = host.indexOf(":");
        if (index != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollectionUtil.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                ipSet.add(inetAddress.getHostAddress());
            }
        }
        return ipSet;
    }

    public static String getLocalhostStr() {
        InetAddress localhost = NetUtil.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        InetAddress candidateAddress = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (null != candidateAddress) continue;
                    candidateAddress = inetAddr;
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (null == candidateAddress) {
            try {
                candidateAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return candidateAddress;
    }

    public static String getLocalMacAddress() {
        return NetUtil.getMacAddress(NetUtil.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        byte[] mac;
        if (null == inetAddress) {
            return null;
        }
        try {
            mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
        }
        catch (SocketException e) {
            throw new UtilException(e);
        }
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        return null;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws IORuntimeException {
        try (SocketChannel channel = SocketChannel.open(NetUtil.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws IORuntimeException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                throw throwable;
            }
        }
        IoUtil.close(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = StrUtil.splitToArray(ip, '.');
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

