/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.LocalPortGenerater;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.Connector;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschSessionPool;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class JschUtil {
    public static final String SSH_NONE = "none";
    private static final LocalPortGenerater portGenerater = new LocalPortGenerater(10000);

    public static int generateLocalPort() {
        return portGenerater.generate();
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JschSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, sshPass);
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        Session session;
        if (StrUtil.isEmpty(sshHost) || sshPort < 0 || StrUtil.isEmpty(sshUser) || StrUtil.isEmpty(sshPass)) {
            return null;
        }
        try {
            session = new JSch().getSession(sshUser, sshHost, sshPort);
            session.setPassword(sshPass);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return session;
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws JschRuntimeException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new JschRuntimeException(e, "From [{}] mapping to [{}] error\uff01", remoteHost, localPort);
            }
            return true;
        }
        return false;
    }

    public static boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
            return true;
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws JschRuntimeException {
        Session session = JschUtil.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        if (session == null) {
            throw new JschRuntimeException("Error to create SSH Session\uff01");
        }
        int localPort = JschUtil.generateLocalPort();
        JschUtil.bindPort(session, remoteHost, remotePort, localPort);
        return localPort;
    }

    public static ChannelSftp openSftp(Session session) {
        Channel channel;
        try {
            channel = session.openChannel("sftp");
            channel.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return (ChannelSftp)channel;
    }

    public static Sftp createSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        return new Sftp(sshHost, sshPort, sshUser, sshPass);
    }

    public static Sftp createSftp(Session session) {
        return new Sftp(session);
    }

    public static ChannelShell openShell(Session session) {
        Channel channel;
        try {
            channel = session.openChannel("shell");
            channel.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return (ChannelShell)channel;
    }

    public static String exec(Session session, String cmd, Charset charset) {
        return JschUtil.exec(session, cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exec(Session session, String cmd, Charset charset, OutputStream errStream) {
        String string;
        ChannelExec channel;
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        try {
            channel = (ChannelExec)session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        channel.setCommand(StrUtil.bytes((CharSequence)cmd, charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.connect();
            in = channel.getInputStream();
            string = IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
                catch (JSchException e2) {
                    throw new JschRuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                JschUtil.close((Channel)channel);
                throw throwable;
            }
        }
        IoUtil.close(in);
        JschUtil.close((Channel)channel);
        return string;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        JschSessionPool.INSTANCE.remove(session);
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }

    public static void close(String key) {
        JschSessionPool.INSTANCE.close(key);
    }

    public static void closeAll() {
        JschSessionPool.INSTANCE.closeAll();
    }
}

