/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Arrangement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] datas;

    public Arrangement(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n) {
        return Arrangement.count(n, n);
    }

    public static long count(int n, int m) {
        if (n == m) {
            return NumberUtil.factorial(n);
        }
        return n > m ? NumberUtil.factorial(n, n - m) : 0L;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i = 1; i <= n; ++i) {
            total += Arrangement.count(n, i);
        }
        return total;
    }

    public List<String[]> select() {
        return this.select(this.datas.length);
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.count(this.datas.length, m));
        this.select(new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.countAll(this.datas.length));
        for (int i = 1; i <= this.datas.length; ++i) {
            result.addAll(this.select(i));
        }
        return result;
    }

    private void select(String[] resultList, int resultIndex, List<String[]> result) {
        int resultLen = resultList.length;
        if (resultIndex >= resultLen) {
            result.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i = 0; i < this.datas.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < resultIndex; ++j) {
                if (!this.datas[i].equals(resultList[j])) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            resultList[resultIndex] = this.datas[i];
            this.select(resultList, resultIndex + 1, result);
        }
    }
}

