/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.nio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NioClient
implements Closeable {
    private SocketChannel channel;

    public NioClient(String host, int port) {
        this.init(new InetSocketAddress(host, port));
    }

    public NioClient(InetSocketAddress address) {
        this.init(address);
    }

    public NioClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open(address);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public NioClient read(ByteBuffer buffer) {
        try {
            this.channel.read(buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public NioClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.channel);
    }
}

