/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.config;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class DatabaseInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitializer.class);
    private static volatile boolean RUN = false;
    private static final String STR_FALSE = "false";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!RUN) {
            String autoCreate = applicationContext.getEnvironment().getProperty("simple.datasource.autoCreateDatabase");
            if (!STR_FALSE.equalsIgnoreCase(autoCreate)) {
                String url = applicationContext.getEnvironment().getProperty("spring.datasource.dynamic.datasource.master.url");
                String username = applicationContext.getEnvironment().getProperty("spring.datasource.dynamic.datasource.master.username");
                String password = applicationContext.getEnvironment().getProperty("spring.datasource.dynamic.datasource.master.password");
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{url, username, password})) {
                    return;
                }
                try {
                    this.initDatabase(url, username, password);
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                }
            }
            RUN = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(String url, String username, String password) throws SQLException {
        String database = this.parseDatabaseName(url);
        url = this.removeDatabaseName(url, database);
        log.info("AutoCreateDatabase\uff1a\u521d\u59cb\u5316\u6570\u636e\u5e93,\u6570\u636e\u5e93\u540d:{},\u8fde\u63a5\u5730\u5740:{} ", (Object)database, (Object)url);
        String mysql = ":mysql:";
        StringBuffer createDataBaseSql = new StringBuffer();
        if (url.contains(mysql)) {
            createDataBaseSql.append("create database if not exists `").append(database).append("` DEFAULT CHARSET utf8mb4 COLLATE utf8mb4_general_ci");
        }
        Connection conn = DriverManager.getConnection(url, username, password);
        Statement stat = conn.createStatement();
        try {
            stat.executeUpdate(createDataBaseSql.toString());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6570\u636e\u5e93\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            stat.close();
            conn.close();
        }
    }

    String parseDatabaseName(String jdbcUrl) {
        String databaseName;
        int index = jdbcUrl.indexOf("://");
        if (index == -1) {
            throw new IllegalArgumentException("can not parse database name from jdbcUrl:" + jdbcUrl);
        }
        int slashIndex = jdbcUrl.indexOf("/", index + 3);
        if (++slashIndex == 0 || slashIndex == jdbcUrl.length()) {
            throw new IllegalArgumentException("can not parse database name from jdbcUrl:" + jdbcUrl);
        }
        int questionMarkIndex = jdbcUrl.indexOf("?", slashIndex);
        String string = databaseName = questionMarkIndex == -1 ? jdbcUrl.substring(slashIndex) : jdbcUrl.substring(slashIndex, questionMarkIndex);
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            throw new IllegalArgumentException("can not parse database name from jdbcUrl:" + jdbcUrl);
        }
        return databaseName;
    }

    String removeDatabaseName(String jdbcUrl, String databaseName) {
        return jdbcUrl.replace("/" + databaseName, "");
    }
}

