/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.config;

import cn.iosd.starter.datasource.mybatis.MapperLocations;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MybatisPlusAutoConfiguration.class})
@ConditionalOnProperty(name={"simple.datasource.locations.enabled"}, havingValue="true", matchIfMissing=true)
public class MapperLocationsAutoConfiguration {
    @Autowired(required=false)
    private List<MapperLocations> mapperProvider;

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer() {
        return properties -> {
            if (this.mapperProvider != null) {
                List<String> mapperLocations = this.mapperProvider.stream().map(MapperLocations::getLocations).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                mapperLocations.addAll(List.of(properties.getMapperLocations()));
                properties.setMapperLocations(mapperLocations.toArray(new String[0]));
            }
        };
    }
}

