/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code;

import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.code.ValidateCodeProcessorHolder;
import org.shoulder.code.processor.ValidateCodeProcessor;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;

public class ValidateCodeFilter
extends OncePerRequestFilter {
    private AuthenticationFailureHandler authenticationFailureHandler;
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    private Set<ValidateCodeRule> needValidateUrlSet = new HashSet<ValidateCodeRule>();
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public ValidateCodeFilter(AuthenticationFailureHandler authenticationFailureHandler, ValidateCodeProcessorHolder validateCodeProcessorHolder) {
        this.authenticationFailureHandler = authenticationFailureHandler;
        this.validateCodeProcessorHolder = validateCodeProcessorHolder;
    }

    public void initFilterBean() throws ServletException {
        super.afterPropertiesSet();
        List<ValidateCodeProcessor> allProcessors = this.validateCodeProcessorHolder.getAllProcessors();
        for (ValidateCodeProcessor allProcessor : allProcessors) {
            this.addValidateRule(allProcessor.processedUrls(), allProcessor.getType());
        }
    }

    protected void addValidateRule(List<String> urls, String type) {
        if (CollectionUtils.isEmpty(urls) || StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        urls.forEach(url -> this.addValidateRule((String)url, type));
    }

    protected void addValidateRule(String url, String type) {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        this.needValidateUrlSet.add(new ValidateCodeRule(url, type));
    }

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        boolean debug = this.logger.isDebugEnabled();
        String type = this.getCodeType(request);
        if (type != null) {
            if (debug) {
                this.logger.debug((Object)("ValidateCodeFilter filter(" + request.getRequestURI() + "), code type is " + type));
            }
            try {
                this.validateCodeProcessorHolder.getProcessor(type).validate(new ServletWebRequest(request, response));
                if (debug) {
                    this.logger.debug((Object)("validateCode success " + request.getRequestURI()));
                }
            }
            catch (Exception e) {
                if (this.authenticationFailureHandler != null) {
                    this.authenticationFailureHandler.onAuthenticationFailure(request, response, new AuthenticationException(e.getMessage() + type, e){});
                }
                throw e;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getCodeType(HttpServletRequest request) {
        String currentRequestUri = request.getRequestURI();
        for (ValidateCodeRule rule : this.needValidateUrlSet) {
            if (!this.pathMatcher.match(rule.getUrlPattern(), currentRequestUri)) continue;
            return rule.getType();
        }
        return null;
    }

    public static class ValidateCodeRule {
        String urlPattern;
        String type;

        public String getUrlPattern() {
            return this.urlPattern;
        }

        public String getType() {
            return this.type;
        }

        public void setUrlPattern(String urlPattern) {
            this.urlPattern = urlPattern;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidateCodeRule)) {
                return false;
            }
            ValidateCodeRule other = (ValidateCodeRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$urlPattern = this.getUrlPattern();
            String other$urlPattern = other.getUrlPattern();
            if (this$urlPattern == null ? other$urlPattern != null : !this$urlPattern.equals(other$urlPattern)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValidateCodeRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $urlPattern = this.getUrlPattern();
            result = result * 59 + ($urlPattern == null ? 43 : $urlPattern.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ValidateCodeFilter.ValidateCodeRule(urlPattern=" + this.getUrlPattern() + ", type=" + this.getType() + ")";
        }

        public ValidateCodeRule() {
        }

        public ValidateCodeRule(String urlPattern, String type) {
            this.urlPattern = urlPattern;
            this.type = type;
        }
    }
}

