/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.shoulder.code.exception.NoSuchValidateCodeProcessorException;
import org.shoulder.code.processor.ValidateCodeProcessor;
import org.springframework.beans.factory.InitializingBean;

public class ValidateCodeProcessorHolder
implements InitializingBean {
    private List<ValidateCodeProcessor> allProcessors;
    private Map<String, ValidateCodeProcessor> processorMap;

    public ValidateCodeProcessorHolder(List<ValidateCodeProcessor> allProcessors) {
        this.allProcessors = allProcessors;
    }

    @Nonnull
    public ValidateCodeProcessor getProcessor(String type) throws NoSuchValidateCodeProcessorException {
        ValidateCodeProcessor processor = this.processorMap.get(type);
        if (processor == null) {
            throw new NoSuchValidateCodeProcessorException("not support such ValidateCodeProcessor(" + type + ")");
        }
        return processor;
    }

    public void afterPropertiesSet() {
        this.processorMap = new HashMap<String, ValidateCodeProcessor>(this.allProcessors.size());
        for (ValidateCodeProcessor processor : this.allProcessors) {
            this.processorMap.put(processor.getType(), processor);
        }
    }

    public List<ValidateCodeProcessor> getAllProcessors() {
        return this.allProcessors;
    }
}

