/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code.processor;

import jakarta.annotation.Nullable;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.exception.ValidateCodeAuthenticationException;
import org.shoulder.code.exception.ValidateCodeException;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.code.processor.ValidateCodeProcessor;
import org.shoulder.code.propertities.BaseValidateCodeProperties;
import org.shoulder.code.store.ValidateCodeStore;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

public abstract class AbstractValidateCodeProcessor<C extends ValidateCodeDTO>
implements ValidateCodeProcessor {
    protected BaseValidateCodeProperties validateCodeProperties;
    protected ValidateCodeGenerator validateCodeGenerator;
    protected ValidateCodeStore validateCodeStore;

    public AbstractValidateCodeProcessor(@Nullable BaseValidateCodeProperties validateCodeProperties, ValidateCodeGenerator validateCodeGenerator, ValidateCodeStore validateCodeStore) {
        this.validateCodeProperties = validateCodeProperties;
        this.validateCodeGenerator = validateCodeGenerator;
        this.validateCodeStore = validateCodeStore;
    }

    @Override
    public void create(ServletWebRequest request) throws ValidateCodeException {
        if (this.isPostOnly() && HttpMethod.POST != request.getHttpMethod()) {
            String errorMsg = "such type of validateCode only support POST.";
            try {
                Objects.requireNonNull(request.getResponse()).sendError(405, "such type of validateCode only support POST.");
            }
            catch (IOException e) {
                throw new IllegalStateException("such type of validateCode only support POST.", e);
            }
        }
        ValidateCodeDTO validateCode = this.validateCodeGenerator.generate(request);
        try {
            this.save(request, validateCode);
            this.send(request, validateCode);
        }
        catch (Exception e) {
            this.remove(request, this.getType());
            throw e;
        }
    }

    private void save(ServletWebRequest request, C validateCode) {
        this.validateCodeStore.save(request, (ValidateCodeDTO)validateCode, this.getType());
    }

    private void remove(ServletWebRequest request, String codeType) {
        this.validateCodeStore.remove(request, codeType);
    }

    public abstract void send(ServletWebRequest var1, C var2) throws ValidateCodeException;

    protected boolean isPostOnly() {
        return false;
    }

    @Override
    public void validate(ServletWebRequest request) {
        String codeInRequest;
        String codeType = this.getType();
        try {
            codeInRequest = ServletRequestUtils.getStringParameter((ServletRequest)request.getRequest(), (String)this.validateCodeProperties.getParameterName());
        }
        catch (ServletRequestBindingException e) {
            throw new ValidateCodeAuthenticationException("cant get validate-code(" + codeType + ") from request.", e);
        }
        if (StringUtils.isBlank((CharSequence)codeInRequest)) {
            throw new ValidateCodeAuthenticationException(codeType + " validate-code is empty(" + codeType + ")");
        }
        ValidateCodeDTO exceptCode = this.validateCodeStore.get(request, codeType);
        if (exceptCode == null || exceptCode.isExpire()) {
            this.validateCodeStore.remove(request, codeType);
            throw new ValidateCodeAuthenticationException(codeType + " validate-code is expire, please retry!");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)exceptCode.getCode(), (CharSequence)codeInRequest)) {
            throw new ValidateCodeAuthenticationException(codeType + " validate-code not correct!");
        }
        this.validateCodeStore.remove(request, codeType);
    }

    @Override
    public List<String> processedUrls() {
        return this.validateCodeProperties.getUrls();
    }
}

