/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code.store.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.store.ValidateCodeStore;
import org.shoulder.core.context.AppContext;
import org.springframework.web.context.request.ServletWebRequest;

public class MemoryValidateCodeRepository
implements ValidateCodeStore {
    private final ConcurrentMap<String, ValidateCodeDTO> cache = new ConcurrentHashMap<String, ValidateCodeDTO>();

    @Override
    public void save(ServletWebRequest request, ValidateCodeDTO code, String validateCodeType) {
        this.cache.put(this.buildCacheKey(validateCodeType), code);
    }

    @Override
    public ValidateCodeDTO get(ServletWebRequest request, String validateCodeType) {
        return (ValidateCodeDTO)this.cache.get(this.buildCacheKey(validateCodeType));
    }

    @Override
    public void remove(ServletWebRequest request, String codeType) {
        this.cache.remove(this.buildCacheKey(codeType));
    }

    protected String buildCacheKey(String validateCodeType) {
        return AppContext.getTenantCode() + ":" + AppContext.getUserId() + ":" + validateCodeType.toUpperCase();
    }
}

