/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code.store.impl;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.store.ValidateCodeStore;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.request.ServletWebRequest;

public class RedisValidateCodeRepository
implements ValidateCodeStore {
    private static final String DEFAULT_KEY_PREFIX = "CAPTCHA_CODE:";
    private RedisTemplate<Object, Object> redisTemplate;
    private final String unionCodePramName;

    public RedisValidateCodeRepository(RedisTemplate redisTemplate, String unionCodePramName) {
        this.redisTemplate = redisTemplate;
        this.unionCodePramName = unionCodePramName;
    }

    @Override
    public void save(ServletWebRequest request, ValidateCodeDTO code, String type) {
        ValidateCodeDTO codeCopy = new ValidateCodeDTO(code.getCode(), code.getExpireTime());
        this.redisTemplate.opsForValue().set((Object)this.buildKey(request, type), (Object)codeCopy, 10L, TimeUnit.MINUTES);
    }

    @Override
    public ValidateCodeDTO get(ServletWebRequest request, String type) {
        Object value = this.redisTemplate.opsForValue().get((Object)this.buildKey(request, type));
        if (value == null) {
            return null;
        }
        return (ValidateCodeDTO)value;
    }

    @Override
    public void remove(ServletWebRequest request, String type) {
        this.redisTemplate.delete((Object)this.buildKey(request, type));
    }

    protected String buildKey(ServletWebRequest request, String type) {
        String unionCode = request.getHeader(this.unionCodePramName);
        if (StringUtils.isBlank((CharSequence)unionCode)) {
            throw new IllegalStateException("please add the parameter(" + this.unionCodePramName + ") in your requests!");
        }
        return DEFAULT_KEY_PREFIX + unionCode + ":" + type;
    }
}

