/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.code.store.impl;

import jakarta.servlet.http.HttpSession;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.store.ValidateCodeStore;
import org.springframework.web.context.request.ServletWebRequest;

public class SessionValidateCodeRepository
implements ValidateCodeStore {
    private static final String DEFAULT_KEY_PREFIX = "CAPTCHA_CODE:";

    @Override
    public void save(ServletWebRequest request, ValidateCodeDTO code, String validateCodeType) {
        ValidateCodeDTO codeCopy = new ValidateCodeDTO(code.getCode(), code.getExpireTime());
        request.getRequest().getSession().setAttribute(this.buildSessionKey(validateCodeType), (Object)codeCopy);
    }

    @Override
    public ValidateCodeDTO get(ServletWebRequest request, String validateCodeType) {
        return (ValidateCodeDTO)request.getRequest().getSession().getAttribute(this.buildSessionKey(validateCodeType));
    }

    @Override
    public void remove(ServletWebRequest request, String codeType) {
        HttpSession session = request.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(this.buildSessionKey(codeType));
        }
    }

    protected String buildSessionKey(String validateCodeType) {
        return DEFAULT_KEY_PREFIX + validateCodeType.toUpperCase();
    }
}

