/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.browser;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shoulder.core.dto.response.BaseResponse;
import org.shoulder.core.exception.CommonErrorCodeEnum;
import org.shoulder.core.exception.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BrowserAuthEndpoint {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String signInPage;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public BrowserAuthEndpoint(String signInPage) {
        this.signInPage = signInPage;
    }

    @RequestMapping(value={"/authentication/require"})
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public BaseResponse requireAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String redirectSignInUrl = this.signInPage + "?_auth_fail_reason=" + request.getAttribute("_auth_fail_reason");
        if (savedRequest != null) {
            String targetUrl = savedRequest.getRedirectUrl();
            this.log.debug("authentication when request to: {}", (Object)targetUrl);
            List headerAccepts = savedRequest.getHeaderValues("Accept");
            for (String headerAccept : headerAccepts) {
                if (!headerAccept.contains("text/html")) continue;
                this.redirectStrategy.sendRedirect(request, response, redirectSignInUrl);
            }
            return new BaseResponse((ErrorCode)CommonErrorCodeEnum.AUTH_401_NEED_AUTH);
        }
        if (request.getHeader("Accept").contains("text/html")) {
            this.redirectStrategy.sendRedirect(request, response, redirectSignInUrl);
        }
        return new BaseResponse((ErrorCode)CommonErrorCodeEnum.AUTH_401_NEED_AUTH);
    }
}

