/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.browser.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shoulder.core.util.StringUtils;
import org.shoulder.security.ResponseUtil;
import org.shoulder.security.authentication.browser.handler.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class BrowserAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResponseType responseType;

    public BrowserAuthenticationFailureHandler(ResponseType responseType, String authFailUrl) {
        this.responseType = responseType;
        if (StringUtils.isNotBlank((CharSequence)authFailUrl)) {
            super.setDefaultFailureUrl(authFailUrl);
            super.setUseForward(true);
        }
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.log.info("authentication FAIL.");
        if (ResponseType.JSON.equals((Object)this.responseType)) {
            this.log.debug("json response for {}", (Object)request.getRequestURI());
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(ResponseUtil.jsonMsg(exception.getMessage()));
        } else {
            this.log.debug("redirect for {}", (Object)request.getRequestURI());
            request.setAttribute("_auth_fail_reason", (Object)exception.getMessage());
            super.onAuthenticationFailure(request, response, exception);
        }
    }
}

