/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.browser.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shoulder.core.util.StringUtils;
import org.shoulder.security.ResponseUtil;
import org.shoulder.security.authentication.browser.handler.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class BrowserAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResponseType responseType;

    public BrowserAuthenticationSuccessHandler(ResponseType responseType, String singInSuccessUrl) {
        this.responseType = responseType;
        if (ResponseType.REDIRECT == responseType && StringUtils.isNotBlank((CharSequence)singInSuccessUrl)) {
            this.setAlwaysUseDefaultTargetUrl(true);
            this.setDefaultTargetUrl(singInSuccessUrl);
        }
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.log.debug("authentication SUCCESS.");
        if (ResponseType.JSON.equals((Object)this.responseType)) {
            this.log.debug("json response for {}", (Object)request.getRequestURI());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(ResponseUtil.success());
        } else if (ResponseType.REDIRECT.equals((Object)this.responseType)) {
            this.log.debug("redirect for {}", (Object)request.getRequestURI());
            super.onAuthenticationSuccess(request, response, authentication);
        } else {
            throw new IllegalStateException("");
        }
    }
}

