/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.browser.handler;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shoulder.security.ResponseUtil;
import org.shoulder.security.authentication.browser.handler.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class BrowserLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final ResponseType responseType;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public BrowserLogoutSuccessHandler(ResponseType responseType, String signOutSuccessUrl) {
        this.responseType = responseType;
        if (StrUtil.isNotBlank((CharSequence)signOutSuccessUrl)) {
            this.setAlwaysUseDefaultTargetUrl(true);
            this.setDefaultTargetUrl(signOutSuccessUrl);
        }
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.log.debug("logout SUCCESS.");
        if (ResponseType.JSON.equals((Object)this.responseType)) {
            this.log.debug("json response for {}", (Object)request.getRequestURI());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(ResponseUtil.success());
        } else if (ResponseType.REDIRECT.equals((Object)this.responseType)) {
            this.log.debug("redirect for {}", (Object)request.getRequestURI());
            super.onLogoutSuccess(request, response, authentication);
        } else {
            throw new IllegalStateException("");
        }
    }
}

