/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.browser.session;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.core.dto.response.BaseResponse;
import org.shoulder.core.exception.CommonErrorCodeEnum;
import org.shoulder.core.exception.ErrorCode;
import org.shoulder.core.util.JsonUtils;
import org.shoulder.core.util.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class AbstractSessionStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sessionInvalidUrl;
    private String signInPage;
    private String signOutUrl;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;

    public AbstractSessionStrategy(String sessionInvalidUrl, String signInPage, String signOutUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)sessionInvalidUrl), (String)"url must start with '/' or with 'http(s)'");
        this.sessionInvalidUrl = sessionInvalidUrl;
        this.signInPage = signInPage;
        this.signOutUrl = signOutUrl;
    }

    protected void onSessionInvalid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug("Starting new session (if required) and redirecting to '" + this.sessionInvalidUrl + "'");
        if (this.createNewSession) {
            request.getSession();
        }
        String sourceUrl = request.getRequestURI();
        if (this.isPageRequest(request)) {
            String targetUrl = StringUtils.equals((CharSequence)sourceUrl, (CharSequence)this.signInPage) || StringUtils.equals((CharSequence)sourceUrl, (CharSequence)this.signOutUrl) ? sourceUrl : this.sessionInvalidUrl;
            this.logger.debug("redirectTo:" + targetUrl);
            this.redirectStrategy.sendRedirect(request, response, targetUrl);
        } else {
            BaseResponse needAuthResponse = new BaseResponse((ErrorCode)CommonErrorCodeEnum.AUTH_401_NEED_AUTH);
            String resultMsg = this.buildResponseContent(request);
            needAuthResponse.setMsg(resultMsg);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonUtils.toJson((Object)needAuthResponse));
        }
    }

    protected boolean isPageRequest(HttpServletRequest request) {
        return !ServletUtil.isAjax((HttpServletRequest)request) && request.getHeader("Accept").contains("text/html");
    }

    protected String buildResponseContent(HttpServletRequest request) {
        StringBuilder result = new StringBuilder("session invalid");
        if (this.isConcurrency()) {
            result.append(",it may caused by concurrent logIn.");
        }
        return result.toString();
    }

    protected boolean isConcurrency() {
        return false;
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

