/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.sms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shoulder.security.authentication.sms.PhoneNumAuthenticationToken;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class PhoneNumAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private String phoneNumberParameter = "phoneNumber";
    private boolean postOnly = true;

    public PhoneNumAuthenticationFilter() {
        super((RequestMatcher)new AntPathRequestMatcher("/authentication/sms", "POST"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !"POST".equals(request.getMethod())) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String phoneNumber = this.obtainPhoneNumber(request);
        if (phoneNumber == null) {
            phoneNumber = "";
        }
        phoneNumber = phoneNumber.trim();
        PhoneNumAuthenticationToken authRequest = new PhoneNumAuthenticationToken(phoneNumber);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected String obtainPhoneNumber(HttpServletRequest request) {
        return request.getParameter(this.phoneNumberParameter);
    }

    protected void setDetails(HttpServletRequest request, PhoneNumAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getPhoneNumberParameter() {
        return this.phoneNumberParameter;
    }

    public void setPhoneNumberParameter(String usernameParameter) {
        Assert.hasText((String)usernameParameter, (String)"phoneNumber parameter must not be empty or null");
        this.phoneNumberParameter = usernameParameter;
    }
}

