/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.sms;

import org.shoulder.security.authentication.PhoneNumAuthenticateService;
import org.shoulder.security.authentication.sms.PhoneNumAuthenticationToken;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class PhoneNumAuthenticationProvider
implements AuthenticationProvider {
    private PhoneNumAuthenticateService phoneNumAuthenticateService;

    public PhoneNumAuthenticationProvider(@NonNull PhoneNumAuthenticateService phoneNumAuthenticateService) {
        this.phoneNumAuthenticateService = phoneNumAuthenticateService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        PhoneNumAuthenticationToken authenticationToken = (PhoneNumAuthenticationToken)authentication;
        String phoneNumber = (String)authenticationToken.getPrincipal();
        UserDetails user = this.phoneNumAuthenticateService.loadUserByPhoneNum(phoneNumber);
        if (user == null) {
            throw new InternalAuthenticationServiceException("can't find any userDetail!");
        }
        PhoneNumAuthenticationToken authenticationResult = new PhoneNumAuthenticationToken(user, user.getAuthorities());
        authenticationResult.setDetails(authentication.getDetails());
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return PhoneNumAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public PhoneNumAuthenticateService getPhoneNumAuthenticateService() {
        return this.phoneNumAuthenticateService;
    }

    @Deprecated
    public void setPhoneNumAuthenticateService(PhoneNumAuthenticateService userDetailsService) {
        this.phoneNumAuthenticateService = userDetailsService;
    }
}

