/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.authentication.sms;

import javax.servlet.Filter;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.security.authentication.PhoneNumAuthenticateService;
import org.shoulder.security.authentication.sms.PhoneNumAuthenticationFilter;
import org.shoulder.security.authentication.sms.PhoneNumAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PhoneNumAuthenticationSecurityConfig
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private static final Logger log = LoggerFactory.getLogger(PhoneNumAuthenticationSecurityConfig.class);
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;
    private PhoneNumAuthenticateService phoneNumAuthenticateService;

    public PhoneNumAuthenticationSecurityConfig(AuthenticationSuccessHandler authenticationSuccessHandler, AuthenticationFailureHandler authenticationFailureHandler, PhoneNumAuthenticateService phoneNumAuthenticateService) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.authenticationFailureHandler = authenticationFailureHandler;
        this.phoneNumAuthenticateService = phoneNumAuthenticateService;
    }

    public void configure(HttpSecurity http) throws Exception {
        if (this.phoneNumAuthenticateService == null) {
            log.debug("userAuthenticateService is null, ignore configure");
            return;
        }
        PhoneNumAuthenticationFilter phoneNumAuthenticationFilter = new PhoneNumAuthenticationFilter();
        phoneNumAuthenticationFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        phoneNumAuthenticationFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
        phoneNumAuthenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
        PhoneNumAuthenticationProvider phoneNumAuthenticationProvider = new PhoneNumAuthenticationProvider(this.phoneNumAuthenticateService);
        http.authenticationProvider((AuthenticationProvider)phoneNumAuthenticationProvider).addFilterAfter((Filter)phoneNumAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
    }
}

