/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.email;

import org.apache.commons.lang3.RandomStringUtils;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.security.code.email.EmailValidateCodeType;
import org.shoulder.security.code.email.config.EmailCodeProperties;
import org.springframework.web.context.request.ServletWebRequest;

public class EmailCodeGenerator
implements ValidateCodeGenerator,
EmailValidateCodeType {
    private EmailCodeProperties emailCodeProperties;

    public EmailCodeGenerator(EmailCodeProperties emailCodeProperties) {
        this.emailCodeProperties = emailCodeProperties;
    }

    public ValidateCodeDTO generate(ServletWebRequest request) {
        String code = RandomStringUtils.randomNumeric((int)this.emailCodeProperties.getLength());
        return new ValidateCodeDTO(code, this.emailCodeProperties.getEffectiveSeconds());
    }

    public EmailCodeProperties getEmailCodeProperties() {
        return this.emailCodeProperties;
    }

    public void setEmailCodeProperties(EmailCodeProperties emailCodeProperties) {
        this.emailCodeProperties = emailCodeProperties;
    }
}

