/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.email;

import javax.servlet.ServletRequest;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.exception.ValidateCodeException;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.code.processor.AbstractValidateCodeProcessor;
import org.shoulder.code.propertities.BaseValidateCodeProperties;
import org.shoulder.code.store.ValidateCodeStore;
import org.shoulder.security.code.email.EmailCodeSender;
import org.shoulder.security.code.email.EmailValidateCodeType;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

public class EmailCodeProcessor
extends AbstractValidateCodeProcessor<ValidateCodeDTO>
implements EmailValidateCodeType {
    private final EmailCodeSender emailCodeSender;

    public EmailCodeProcessor(BaseValidateCodeProperties baseValidateCodeProperties, ValidateCodeGenerator validateCodeGenerator, ValidateCodeStore validateCodeStore, EmailCodeSender emailCodeSender) {
        super(baseValidateCodeProperties, validateCodeGenerator, validateCodeStore);
        this.emailCodeSender = emailCodeSender;
    }

    protected boolean isPostOnly() {
        return true;
    }

    public void send(ServletWebRequest request, ValidateCodeDTO validateCode) throws ValidateCodeException {
        try {
            String mobile = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request.getRequest(), (String)"email");
            this.emailCodeSender.send(mobile, validateCode.getCode());
        }
        catch (Exception e) {
            throw new ValidateCodeException("send emailCode fail", (Throwable)e);
        }
    }
}

