/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.img;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.ServletRequest;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.security.code.img.ImageCode;
import org.shoulder.security.code.img.ImageValidateCodeType;
import org.shoulder.security.code.img.config.ImageCodeProperties;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

public class ImageCodeGenerator
implements ValidateCodeGenerator,
ImageValidateCodeType {
    private final String[] FONT_NAMES;
    private final String[] CHARS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private ImageCodeProperties imageCodeProperties;

    public ImageCodeGenerator(ImageCodeProperties imageCodeProperties) {
        this.FONT_NAMES = imageCodeProperties.getFonts().toArray(new String[0]);
        this.imageCodeProperties = imageCodeProperties;
    }

    public ImageCode generate(ServletWebRequest request) {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int width = ServletRequestUtils.getIntParameter((ServletRequest)request.getRequest(), (String)"width", (int)this.imageCodeProperties.getWidth());
        int height = ServletRequestUtils.getIntParameter((ServletRequest)request.getRequest(), (String)"height", (int)this.imageCodeProperties.getHeight());
        int codeLength = this.imageCodeProperties.getLength();
        StringBuilder validateCode = new StringBuilder();
        for (int i2 = 0; i2 < this.imageCodeProperties.getLength(); ++i2) {
            int index = ((Random)random).nextInt(this.CHARS.length);
            validateCode.append(this.CHARS[index]);
        }
        String validateCodeStr = validateCode.toString();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.nextRandomColor(210, 250));
        graphics.fillRoundRect(0, 0, width, height, 0, 0);
        graphics.setColor(this.nextRandomColor(110, 180));
        graphics.setFont(new Font("Times New Roman", 2, height - 10));
        int interferenceLineNum = 128;
        for (i = 0; i < interferenceLineNum; ++i) {
            int x = ((Random)random).nextInt(width);
            int y = ((Random)random).nextInt(height);
            int xl = ((Random)random).nextInt(12);
            int yl = ((Random)random).nextInt(12);
            graphics.drawLine(x, y, x + xl, y + yl);
        }
        graphics.setColor(this.nextRandomColor(30, 140));
        for (i = 0; i < codeLength; ++i) {
            int offset = 5;
            int fontSize = height - 20 + ((Random)random).nextInt(10);
            graphics.setFont(new Font(this.FONT_NAMES[((Random)random).nextInt(this.FONT_NAMES.length)], ((Random)random).nextInt(3), fontSize));
            graphics.drawString(String.valueOf(validateCodeStr.charAt(i)), i * fontSize + 5, fontSize + ((Random)random).nextInt(fontSize >> 1));
        }
        graphics.dispose();
        return new ImageCode(image, validateCodeStr, this.imageCodeProperties.getEffectiveSeconds());
    }

    private Color nextRandomColor(int minLight, int maxLight) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int rbgMax = 255;
        if (minLight < 0 || minLight > maxLight || maxLight > rbgMax) {
            throw new IllegalArgumentException("no such color(min=" + minLight + ",max=" + maxLight + ")!");
        }
        int r = minLight + ((Random)random).nextInt(maxLight - minLight);
        int g = minLight + ((Random)random).nextInt(maxLight - minLight);
        int b = minLight + ((Random)random).nextInt(maxLight - minLight);
        return new Color(r, g, b);
    }
}

