/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.img;

import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.shoulder.code.exception.ValidateCodeException;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.code.processor.AbstractValidateCodeProcessor;
import org.shoulder.code.propertities.BaseValidateCodeProperties;
import org.shoulder.code.store.ValidateCodeStore;
import org.shoulder.security.code.img.ImageCode;
import org.shoulder.security.code.img.ImageValidateCodeType;
import org.springframework.web.context.request.ServletWebRequest;

public class ImageCodeProcessor
extends AbstractValidateCodeProcessor<ImageCode>
implements ImageValidateCodeType {
    public ImageCodeProcessor(BaseValidateCodeProperties baseValidateCodeProperties, ValidateCodeGenerator validateCodeGenerator, ValidateCodeStore validateCodeStore) {
        super(baseValidateCodeProperties, validateCodeGenerator, validateCodeStore);
    }

    public void send(ServletWebRequest request, ImageCode imageCode) throws ValidateCodeException {
        try {
            ImageIO.write((RenderedImage)imageCode.getImage(), "JPEG", (OutputStream)Objects.requireNonNull(request.getResponse()).getOutputStream());
            imageCode.setImage(null);
        }
        catch (Exception e) {
            throw new ValidateCodeException("send validate code fail.", (Throwable)e);
        }
    }
}

